'LoRa Tracker Receiver For MicroMiteII V1_0

'To do

option explicit

DIM INTEGER LORA_NULL
DIM INTEGER LORA_Data
DIM INTEGER LORA_Reg
DIM INTEGER LORA_TXBUFF(255)
DIM INTEGER LORA_RXBUFF(255)
DIM INTEGER LORA_RXStart
DIM INTEGER LORA_RXEnd
DIM INTEGER LORA_TXStart
DIM INTEGER LORA_TXEnd
DIM INTEGER LORA_CMDBUFF(32)
DIM INTEGER LORA_FCRCerror
DIM INTEGER LORA_FRXTimeout
DIM INTEGER LORA_FTXOK
DIM INTEGER LORA_FRXOK
DIM INTEGER LORA_RXPacketType
DIM INTEGER LORA_TXPacketType
DIM INTEGER LORA_TXDestination
DIM INTEGER LORA_TXSource
DIM INTEGER LORA_RXDestination
DIM INTEGER LORA_RXSource
DIM INTEGER LORA_BackGroundRSSI
DIM INTEGER LORA_PacketRSSI
DIM INTEGER LORA_PacketSNR
DIM INTEGER LORA_RXpacketCount
DIM INTEGER LORA_CRCerrorcount
DIM INTEGER LORA_TXpacketCount
DIM INTEGER LORA_TXPacketL
DIM INTEGER LORA_RXPacketL
DIM INTEGER LORA.FDeviceError
DIM FLOAT LORA.Frequency
DIM INTEGER LORA_TXBUFF2(255)
DIM INTEGER LORA_RXBUFF2(255)        
DIM INTEGER LORA_TXBUFF3(255)


CONST LORA_PNSS = 11      'pin number where the NSS line for the LoRa device is connected.
CONST LORA_PLED1 = 12     'Pin number for LED1
CONST LORA.PReset = 23    'Pin where LoRa device reset line is connected
CONST LORA_PPWMCH = 2     'Channel number for PWM direct MOD, used for FM tones.
CONST ARS.RTCAdr = &H51   'Address of PCF8563
CONST ARS.EEAdr = &H50    'Address of EEPROM  

CONST TopHeader = 1       'line\row number of top header line
CONST BotHeader = 10      'line\row number of bottom header line
CONST ScrollStart = 12    'line\row where scroll starts
CONST ScrollEnd = 24       'line\row where scroll end
            
CONST ARS.LED1 = 12
CONST ARS.LED2 = 35
CONST ARS.LED3 = 36
CONST ARS.LED4 = 14      
CONST ARS.BUZZ1 = 32
CONST ARS.TEMP1 = 37
CONST ARS.TEMP2= 5
CONST ARS.SW1 = 13
CONST ARS.POWER = 38  
 
'SX1278 Register names     
CONST LORA_RegFifo = &H00
CONST LORA_WRegFifo = &H80
CONST LORA_RegOpMode = &H01
CONST LORA_RegFdevLsb = &H05
CONST LORA_RegFrMsb = &H06
CONST LORA_RegFrMid = &H07
CONST LORA_RegFrLsb = &H08
CONST LORA_RegPaConfig = &H09      
CONST LORA_RegOcp = &H0B
CONST LORA_RegLna = &H0C
CONST LORA_RegFifoAddrPtr = &H0D
CONST LORA_RegFifoTxBaseAddr = &H0E
CONST LORA_RegFiFORxBaseAddr = &H0F
CONST LORA_RegFiFORxCurrentAddr = &H10
CONST LORA_RegIrqFlagsMask = &H11
CONST LORA_RegIrqFlags = &H12
CONST LORA_RegRxNbBytes = &H13
CONST LORA_RegRxVMsb = &H14
CONST LORA_RegRxVLsb = &H15
CONST LORA_RegRxMsb = &H16
CONST LORA_RegRxLsb = &H17
     
'LORA names for bandwidth settings
CONST LORA_BW7_8 = 0      '7.8khz
CONST LORA_BW10_4 = 16    '10.4khz
CONST LORA_BW15_6 = 32    '15.6khz
CONST LORA_BW20_8 = 48    '20.8khz
CONST LORA_BW31_2 = 64    '31.2khz
CONST LORA_BW41_7 = 80    '41.7khz
CONST LORA_BW62_5 = 96    '62.5khz
CONST LORA_BW125 = 112    '125khz
CONST LORA_BW250 = 128    '250khz
CONST LORA_BW500 = 144    '500khz           
      
'Spreading Factor
CONST LORA_SF6 = 6
CONST LORA_SF7 = 7
CONST LORA_SF8 = 8
CONST LORA_SF9 = 9
CONST LORA_SF10 = 10
CONST LORA_SF11 = 11
CONST LORA_SF12 = 12           
     

MAIN:

OPEN "COM2:9600" AS #1

PRINT #1,"Program.Setup"
SETPIN LORA_PNSS, DOUT
PIN(LORA_PNSS) = 1
SPI OPEN 1000000, 0, 8

LORA.Setup								'Do the initial LoRa Setup

end

'**********************************************************
'Start LoRa Library Routines
'***********************************************************
      
SUB LORA.Setup
      'initialise LoRa device registers and check its responding
      PRINT #1,"LORA.Setup"
      IF LORA.Checkdevice() = 0 then
        PRINT #1,"ERROR, Device not Working"
      ELSe
        PRINT #1,"Device OK"
      END IF        
END SUB

      
FUNCTION LORA.Checkdevice() AS INTEGER
      'check there is a device out there
      PRINT #1,"LORA.Checkdevice"
      'PAUSE 1000
      LOCAL INTEGER LORA_LVAR1, LORA_LVAR2,LORA_LVAR3
      'check the 3 frequency setting registers.
      PIN(LORA_PNSS) = 0
      LORA_LVAR1 = SPI(LORA_RegFrMsb)     'write out the first frequency register to read
      LORA_LVAR1 = SPI(0)                 'Read RegFrMSB
      LORA_LVAR2 = SPI(0)                 'Read RegFrMid
      LORA_LVAR3 = SPI(0)                 'Read RegFrLSB
      PIN(LORA_PNSS) = 1
      if LORA_LVAR1  <> &H5A OR LORA_LVAR2 <> &HAA OR LORA_LVAR3 <> &HA5 then
        LORA.Checkdevice = 0
        LORA.FDeviceError = 0
      else
        LORA.Checkdevice = 1
        LORA.FDeviceError = 1
      end if
END FUNCTION

SUB LORA.ResetDev
      PRINT #1,"LORA.ResetDev"
      PIN(LORA.PReset) = 0
      PAUSE 1
      PIN(LORA.PReset) = 1
      PAUSE 1000
END SUB
